/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@SpringBootApplication
public class Application
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    @Autowired
    JdbcTemplate jdbcTemplate;

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        log.info("Creating tables");
        this.jdbcTemplate.execute("DROP TABLE exercises IF EXISTS");
        this.jdbcTemplate.execute("CREATE TABLE exercises(exercise_id IDENTITY, name VARCHAR(100))");
        this.jdbcTemplate.execute("INSERT INTO exercises(name) VALUES('Deadlift')");
        this.jdbcTemplate.execute("INSERT INTO exercises(name) VALUES('Back Squat')");
        this.jdbcTemplate.execute("INSERT INTO exercises(name) VALUES('Bench Press')");
        this.jdbcTemplate.execute("DROP TABLE users IF EXISTS");
        this.jdbcTemplate.execute("CREATE TABLE users (user_id IDENTITY,firstname VARCHAR(200),lastname VARCHAR(200),)");
        this.jdbcTemplate.execute("INSERT INTO users(firstname, lastname) VALUES('Kaj', 'Str\u00f6m')");
        this.jdbcTemplate.execute("INSERT INTO users(firstname, lastname) VALUES('Ville', 'Viklund')");
        this.jdbcTemplate.execute("DROP TABLE sets IF EXISTS");
        this.jdbcTemplate.execute("CREATE TABLE sets(set_id IDENTITY,user_id INT,exercise_id INT NOT NULL,performed_on DATE NOT NULL, weight DOUBLE NOT NULL,repetitions TINYINT NOT NULL, estimated_1rm DOUBLE NOT NULL,FOREIGN KEY(user_id) REFERENCES users(user_id),FOREIGN KEY(exercise_id) REFERENCES exercises(exercise_id))");
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

