/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker.domain;

import fi.kajstrom.repmaxtracker.domain.Set;
import fi.kajstrom.repmaxtracker.domain.exception.UserNotFoundException;
import fi.kajstrom.repmaxtracker.infrastructure.database.SetGateway;
import fi.kajstrom.repmaxtracker.infrastructure.database.UserGateway;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="setService")
public class SetService {
    private SetGateway setGateway;
    private UserGateway userGateway;

    @Autowired
    public SetService(SetGateway setGateway, UserGateway userGateway) {
        this.setGateway = setGateway;
        this.userGateway = userGateway;
    }

    public Integer addSet(long exerciseId, long userId, Date performedOn, Double weight, Integer repetitions) {
        Set set = new Set();
        Double estimated1Rm = this.calculate1Rm(weight, repetitions);
        set.setExerciseId(exerciseId).setUserId(userId).setPerformedOn(performedOn).setWeight(weight).setRepetitions(repetitions).setEstimated1Rm(estimated1Rm);
        return this.setGateway.addSet(set);
    }

    public List<Set> allSets() {
        return this.setGateway.allSets();
    }

    public List<Set> getUserSets(long userId) throws UserNotFoundException {
        this.guardAgainstMissingUsers(userId);
        return this.setGateway.getUserSets(userId);
    }

    public Set getSet(long setId) {
        return this.setGateway.getSet(setId);
    }

    public Boolean deleteUserSet(long userId, long setId) throws UserNotFoundException {
        this.guardAgainstMissingUsers(userId);
        return this.setGateway.deleteUserSet(userId, setId);
    }

    private Double calculate1Rm(Double weight, Integer repetitions) {
        if (repetitions.equals(1)) {
            return weight;
        }
        return weight * (double)repetitions.intValue() * 0.0333 + weight;
    }

    private void guardAgainstMissingUsers(long userId) throws UserNotFoundException {
        if (!this.userGateway.userExists(userId).booleanValue()) {
            throw new UserNotFoundException(String.format("No user found with user id: %s.", userId));
        }
    }
}

