/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker.infrastructure.database;

import fi.kajstrom.repmaxtracker.domain.Set;
import fi.kajstrom.repmaxtracker.infrastructure.database.rowmapper.SetRowMapper;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Component;

@Component(value="setGateway")
public class SetGateway {
    private JdbcTemplate jdbcTemplate;
    private SetRowMapper setRowMapper;

    @Autowired
    public SetGateway(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.setRowMapper = new SetRowMapper();
    }

    public Integer addSet(Set set) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        String insertSQL = "INSERT INTO sets (exercise_id, user_id, performed_on, weight, repetitions, estimated_1rm) VALUES(?, ?, ?, ?, ?, ?)";
        this.jdbcTemplate.update(connection -> {
            PreparedStatement ps = connection.prepareStatement(insertSQL, new String[]{"set_id"});
            Date performedOn = new Date(set.getPerformedOn().getTime());
            ps.setLong(1, set.getExerciseId());
            ps.setLong(2, set.getUserId());
            ps.setDate(3, performedOn);
            ps.setDouble(4, set.getWeight());
            ps.setInt(5, set.getRepetitions());
            ps.setDouble(6, set.getEstimated1Rm());
            return ps;
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    public List<Set> allSets() {
        return this.jdbcTemplate.query("SELECT * FROM sets", (RowMapper)this.setRowMapper);
    }

    public List<Set> getUserSets(long userId) {
        String sql = "SELECT * FROM sets WHERE user_id = ? ORDER BY performed_on ASC";
        return this.jdbcTemplate.query("SELECT * FROM sets WHERE user_id = ? ORDER BY performed_on ASC", new Object[]{userId}, (RowMapper)this.setRowMapper);
    }

    public Set getSet(long setId) {
        try {
            return (Set)this.jdbcTemplate.queryForObject("SELECT * FROM sets WHERE set_id = ?", new Object[]{setId}, (RowMapper)this.setRowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public Boolean deleteUserSet(long userId, long setId) {
        String sql = "DELETE FROM sets WHERE user_id = ? AND set_id = ?";
        Object[] params = new Object[]{userId, setId};
        int deleteCount = this.jdbcTemplate.update("DELETE FROM sets WHERE user_id = ? AND set_id = ?", params);
        return deleteCount == 1;
    }
}

