/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker.resources;

import fi.kajstrom.repmaxtracker.domain.Set;
import fi.kajstrom.repmaxtracker.domain.SetService;
import fi.kajstrom.repmaxtracker.resources.ResourceNotFoundException;
import fi.kajstrom.repmaxtracker.resources.SetAddResource;
import fi.kajstrom.repmaxtracker.resources.SetResource;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/sets"})
public class SetController {
    private static final Logger log = LoggerFactory.getLogger(SetController.class);
    @Autowired
    private SetService setService;

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<?> addSet(@RequestBody SetAddResource set) {
        Integer setId = this.setService.addSet(set.getExerciseId(), set.getUserId(), set.getPerformedOn(), set.getWeight(), set.getRepetitions());
        URI location = ServletUriComponentsBuilder.fromCurrentRequest().path("/{set_id}").buildAndExpand(new Object[]{setId}).toUri();
        return ResponseEntity.created((URI)location).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SetResource> getSets() {
        return this.setService.allSets().stream().map(SetResource::from).collect(Collectors.toList());
    }

    @RequestMapping(value={"/{setId}"})
    @ResponseBody
    public SetResource getSet(@PathVariable(value="setId") String reqSetId) throws ResourceNotFoundException {
        long setId = Long.parseLong(reqSetId);
        Set set = this.setService.getSet(setId);
        if (set == null) {
            throw new ResourceNotFoundException(String.format("No set found with id: %s", setId));
        }
        return SetResource.from((Set)set);
    }
}

