/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker.resources;

import fi.kajstrom.repmaxtracker.domain.Set;
import java.util.Date;
import javax.validation.constraints.NotNull;

public class SetResource {
    private final long setId;
    private final long exerciseId;
    private final long userId;
    private final Date performedOn;
    private final Double weight;
    private final Integer repetitions;
    private final Double estimated1Rm;

    @NotNull
    public static SetResource from(Set set) {
        return new SetResource(set.getSetId(), set.getExerciseId(), set.getUserId(), set.getPerformedOn(), set.getWeight(), set.getRepetitions(), set.getEstimated1Rm());
    }

    public SetResource(long setId, long exerciseId, long userId, Date performedOn, Double weight, Integer repetitions, Double estimated1Rm) {
        this.setId = setId;
        this.exerciseId = exerciseId;
        this.userId = userId;
        this.performedOn = performedOn;
        this.weight = weight;
        this.repetitions = repetitions;
        this.estimated1Rm = estimated1Rm;
    }

    public SetResource() {
        this.setId = 0L;
        this.exerciseId = 0L;
        this.userId = 0L;
        this.performedOn = null;
        this.weight = 0.0;
        this.repetitions = 0;
        this.estimated1Rm = 0.0;
    }

    public long getSetId() {
        return this.setId;
    }

    public long getExerciseId() {
        return this.exerciseId;
    }

    public long getUserId() {
        return this.userId;
    }

    public Date getPerformedOn() {
        return this.performedOn;
    }

    public Double getWeight() {
        return this.weight;
    }

    public Integer getRepetitions() {
        return this.repetitions;
    }

    public Double getEstimated1Rm() {
        return this.estimated1Rm;
    }
}

