/*
 * Decompiled with CFR 0.152.
 */
package fi.kajstrom.repmaxtracker.resources;

import fi.kajstrom.repmaxtracker.domain.SetService;
import fi.kajstrom.repmaxtracker.resources.SetResource;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/users/{userId}/sets"})
public class UserSetsController {
    @Autowired
    private SetService setService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public List<SetResource> getUserSets(@PathVariable(value="userId") String reqUserId) throws Exception {
        Long userId = Long.parseLong(reqUserId);
        return this.setService.getUserSets(userId.longValue()).stream().map(SetResource::from).collect(Collectors.toList());
    }

    @RequestMapping(path={"/{setId}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteUsersSet(@PathVariable(value="userId") String reqUserId, @PathVariable(value="setId") String reqSetId) throws Exception {
        Long userId = Long.parseLong(reqUserId);
        Long setId = Long.parseLong(reqSetId);
        Boolean deleted = this.setService.deleteUserSet(userId.longValue(), setId.longValue());
        if (!deleted.booleanValue()) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().build();
    }
}

